/*******************************************************************************
*                         USB4ALLAPI Library Version 1.0                       *
*******************************************************************************/
#include "ModuleMap.h"

ModuleMap::ModuleMap() {}

ModuleMap::~ModuleMap() { }

void ModuleMap::add(int id, int serial, int handler, int dscin, int dscout) {

    endp eps;
    if (!exists(id)) {
        eps.serial = serial;
        eps.handler = handler;
        eps.dscin = dscin;
        eps.dscout = dscout;
        mapa.insert(pair<int,endp>(id,eps));
    }
}

void ModuleMap::remove(int id) {

    if (exists(id)) {
        mapa.erase(id);
    }
}

bool ModuleMap::exists(int id) {

    map<int,endp>::iterator it;
    it = mapa.find(id);
    return (it != mapa.end());
}

bool ModuleMap::isempty() {

    return (mapa.empty());
}

int ModuleMap::size() {

    return(mapa.size());
}

int ModuleMap::getModuleID(int index) {

    map<int,endp>::iterator it;

    it = mapa.begin();
    for (int i=0; i<index ; i++) {
        it++;
    }
    return it->first;
}

int ModuleMap::getEndpointSend(int id) {

    endp eps;
    map<int,endp>::iterator it;
    it = mapa.find(id);
    if (it != mapa.end()) {
        eps = it->second;
        return eps.dscout;
    }
    return 0;
}

int ModuleMap::getEndpointRecv(int id) {

    endp eps;
    map<int,endp>::iterator it;
    it = mapa.find(id);
    if (it != mapa.end()) {
        eps = it->second;
        return eps.dscin;
    }
    return 0;
}

int ModuleMap::getSerial(int id) {

    endp eps;
    map<int,endp>::iterator it;
    it = mapa.find(id);
    if (it != mapa.end()) {
        eps = it->second;
        return eps.serial;
    }
    return 0;
}

int ModuleMap::getHandler(int id) {

    endp eps;
    map<int,endp>::iterator it;
    it = mapa.find(id);
    if (it != mapa.end()) {
        eps = it->second;
        return eps.handler;
    }
    return 0;
}
